/******************************************************************************
 CGotoLine.c

				CGotoLine Dialog Director Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 10:36 PM Thu, Aug 5, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the dialog class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CGotoLine.h"
#include "GotoLineItems.h"

#include <CIntegerTextAble.h>
#include <CStaticText.h>
#include <CAbstractText.h>



/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICGotoLine

	Initialize the dialog

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void	CGotoLine::ICGotoLine(CDirectorOwner *aSupervisor, CAbstractText *editText,
			long currLine)

{
		// Initialize data members that must be set up before
		// BeginData is called here
	fLine = currLine;
	fEditText = editText;

	x_CGotoLine::Ix_CGotoLine(aSupervisor);

		// Initialize any other data members here
}


/******************************************************************************
 BeginData

	Set up initial pane values
******************************************************************************/

void CGotoLine::BeginData(CGotoLineData *initial)

{
	long max;
	Str255	s1, s2;

	 	//	Superclass calls BeginData once after the window is created
	 	//	to gather the initial values for the dialog panes. Note that
	 	//	BeginData is called *before* Ix_CGotoLine returns. If you
	 	//	do not override this function, all values are initially
	 	//	zero or null.

	initial->fGotoLine_Edit2 = fLine;
	max = fEditText->GetNumLines() - 1;
	fGotoLine_Edit2->SpecifyRange(1, max);

	CopyPString("\p(1..", s1);
	NumToString(max, s2);
	ConcatPStrings(s1, s2);
	ConcatPStrings(s1, "\p)");
	fGotoLine_Limit->SetTextString(s1);
}


/******************************************************************************
 UpdateData
 
 	React to changes by the user (or the program)
******************************************************************************/

void CGotoLine::UpdateData(CGotoLineUpdate *update, long itemNo)

{
		//	UpdateData is called every time the user or the program
		//	changes the value of a dialog pane. (Changes you make to
		//	panes during a call to UpdateData do not result in
		//	recursive calls to UpdateData.)

		//	Override to dynamically update other program objects.
		//	Note that *only* the value corresponding to itemNo is present in
		//	the update record. If you need the values of other panes,
		//	you must ask the panes for them.
}


/******************************************************************************
 EndData
 
 	Receive final values from the dialog
******************************************************************************/

void CGotoLine::EndData(CGotoLineData *final)

{
		//	The values of all panes are returned by this function,
		//	which is called just before Close for a modeless dialog,
		//	or just before returning from DoModalDialog.
		
		//	If DoModalDialog returns cmdCancel, EndData is called
		//	with the values initially supplied to BeginData, allowing
		//	you to back out any intermediate changes made in response
		//	to UpdateData. If you do not use UpdateData, you can
		//	test the value of dismissCmd to see whether to respond
		//	to EndData.

	if (dismissCmd == cmdOK)
		fLine = final->fGotoLine_Edit2;
}

/****
 * GetLineNumber()
 *
 *	Return line number read in from the dialog box
 *
 ****/

long CGotoLine::GetLineNumber(void)
{
	return fLine;
}
